//
//  TVAskDialogController.m
//  AskTest
//
//  Created by Uli Kusterer on 21.06.05.
//  Copyright 2005 M. Uli Kusterer. All rights reserved.
//  Modified by creysoft on 25.06.05
//  . Changed NSTextViews to NSTextFields
//  . Rewrote sizing code to work with NSTextFields
//

#import "TVAskDialogController.h"


@implementation TVAskDialogController

-(NSString*) show:(NSString*)promptText withDefault:(NSString*)defaultText
{
    NSRect          windowBox = [[promptField window] frame];
    NSRect          textfieldBox;
    NSRect          oldTextfieldBox;
    
    [editField setStringValue: defaultText];
    [promptField setStringValue: promptText];
	
	oldTextfieldBox = [promptField frame];
	textfieldBox = oldTextfieldBox; 
	windowBox = [[promptField window] frame];
	
	textfieldBox.size.height = 10000.0; // an arbitrary large number
	textfieldBox.size = [[promptField cell] cellSizeForBounds:textfieldBox];
	
	if(NSHeight(textfieldBox) > NSHeight(oldTextfieldBox))
		windowBox.size.height += (NSHeight(textfieldBox) - NSHeight(oldTextfieldBox));
	
	[[promptField window] setFrame:windowBox display:NO];
			    
    int result = [NSApp runModalForWindow: [promptField window]];
    NSLog( @"Button %d clicked.", result );
    
    [[promptField window] orderOut: nil];   // Hide window until next use.
	return [editField stringValue]; 
}

-(void) buttonClicked: (id)sender
{
    NSLog( @"Clicked: %@", [sender title] );
    [NSApp stopModalWithCode: [sender tag]];    // I've set buttons' tag numbers to 1 and 2.
}

@end
